*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Tebuprimphos oxon                                    *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\SAS code Final Models\Diagnostics.SAS";

libname EPA "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\kapp data";
/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/



data tebuprimphosoxon;
     set epa.tebuprimphosoxon;
run;
proc sort data=tebuprimphosoxon;
     by id;
run;


ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\TebuprimphosOxon - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=Tebuprimphosoxon);
ods rtf close;


*===> Human vs. Rat;


title "Human vs. Rat: final model 3";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=tebuprimphosoxon /**/ method=firo tech=newrap lis=3 maxiter=10000;
      PARMS ha=0.9069
			hb=0.1660
			ra=0.6523
			rb=0.5251	
			gha=0.06099	ghab=2.1844		ghb=.7762
			gra=.06015	grab=0.06942	grb=.1435
			S2E=0.08759;

            rha=ha+uha;
			rra=ra+ura;
            rhb=hb+uhb;
			rrb=rb+urb;
            PRED = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-5 + H_I__M + rrb*Rat*1e-6 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ura urb ~ normal([0, 0, 0, 0],	[gha, 
												 		 ghab*1e-2, ghb*1e-2,
														 0,    	  0,   gra,
														 0,       0,   grab, grb]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/(rb*1e-1));
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  predict pred out=Resid_HR;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\TebuprimphosOxon human-rat.rtf" startpage=no;
%DiagnosticsHR(chemical=TebuprimphosOxon, model=3)
ods rtf close;
%Calculate_Ki(chemical=TebuprimphosOxon, Hadj=1e-5, Radj=1e-6);


*===> Adult vs. Infant;

title "final model 2b - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=TebuprimphosOxon(where=(Human=1))  tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=1.00	adB=0.2001
			ia=.7999 iB=.1001
			gha=0.01013 	ghab=0.002552	ghb=0.006125
			S2E=0.379;

			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-5 + H_I__M*adult + rib*1e-5*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-4);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_AI; 
	  ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	  predict pred out=Resid_AI;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\TebuprimphosOxon Adult-Infant.rtf" startpage=no;
%DiagnosticsAI(chemical=TebuprimphosOxon, model=2)
ods rtf close;


*===> Male vs. Female;

title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=TebuprimphosOxon(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ma=.9482 mb= .1683
			fa=.8673 fB=.1613
			gha=.09652 	ghab=2.9814	ghb=0.009530
			S2E=.05965;

            rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
            PRED = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-5 + H_I__M*male + rfb*female*1e-5 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab*1e-2, ghb]) SUBJECT=ID out=RandID_MF;  
	  ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  predict pred out=Resid_MF;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\TebuprimphosOxon Male-Female.rtf" startpage=no;
%DiagnosticsMF(chemical=TebuprimphosOxon, model=2)
ods rtf close;



*===> Caucasian vs. Other Races;


title "Final model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=TebuprimphosOxon(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ca=.9342	cB=.1758
			ora=.8558 orB=0.1483
			gha=.9761	ghab=.3012	ghb=.009655
			S2E=.06035;

            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-5 + H_I__M*caucasian + rorb*otherrace*1e-5 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb]) SUBJECT=ID out=RandID_CO; 
	  ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasian ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	predict pred out=Resid_CO;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\TebuprimphosOxon Caucasian-Other Races.rtf" startpage=no;
%DiagnosticsCO(chemical=TebuprimphosOxon, model=2)
ods rtf close;
